import inspect
import logging.config
from os.path import abspath, dirname

from lcconfig import ConsoleSettingsConfig

DATABASE_PATH = '/etc/hedge/hedge.db'
cfg = ConsoleSettingsConfig().load()
BD = cfg.as_typed_dict('BoxData')
ADMINURL = BD.get('adminurl', '')
SYSTEM_NAME = BD.get("name", '')

email = cfg.as_typed_dict(cfg.email_section())
DEFAULT_FROM_EMAIL = email.get('from_address', '').strip()
EMAIL_HOST = email.get('host', '').strip()
EMAIL_PORT = email.get('port', 587)
EMAIL_HOST_USER = email.get('username', '').strip()
EMAIL_HOST_PASSWORD = email.get('password', '').strip()
EMAIL_RECIPIENT = 'support@compassfoundation.io'

filename = inspect.getframeinfo(inspect.currentframe()).filename
ROOT_DIR = dirname(abspath(filename))
TEMPLATES = f'{ROOT_DIR}/templates'

SHADOW_FIELDS = (
    'sp_namp',
    'sp_pwdp',
    'sp_lstchg',
    'sp_min',
    'sp_max',
    'sp_warn',
    'sp_inact',
    'sp_expire',
    'sp_flag',
)

LOGGING = {
    'version': 1,
    'disable_existing_loggers': False,
    'formatters': {
        'default_formatter': {
            'format': "[%(asctime)s] %(levelname)s [%(name)s:%(lineno)s] %(message)s",
            'datefmt': "%Y-%m-%d %H:%M:%S",
        },
    },
    'handlers': {
        'file': {
            'level': 'INFO',
            'class': 'logging.FileHandler',
            'filename': '/var/log/hedge/hedge.log',
            'formatter': 'default_formatter',
        },
        'console': {
            'class': 'logging.StreamHandler',
            'formatter': 'default_formatter',
        },
    },
    'loggers': {
        'hedge': {
            'handlers': ['file'],
            'propagate': True,
            'level': 'INFO',
        },
    },
}

logging.config.dictConfig(LOGGING)
