class BaseActor:
    """
    Respond when receiving events that:

    * a file has been created/modified
    * a message has been received from a socket
    """

    def process(self, **kwargs):
        """
        Process file or message contents
        and take necessary action.
        """
        raise NotImplementedError

    def actions(self, **kwargs):
        """
        Get action classes and perform them.
        """
        raise NotImplementedError

    def __str__(self):
        return self.__class__.__name__


__all__ = [
    'BaseActor',
]
