import pickle
import socket
import threading
import unicodedata


def remove_control_characters(s):
    """
    Remove unicode control characters so we don't get
    strings like "Tanks\x00"
    """
    return "".join(ch for ch in s if unicodedata.category(ch)[0] != "C")


class GladeThread(threading.Thread):

    def __init__(self, *args, **kwargs) -> None:
        super().__init__(*args, **kwargs)

        # The shutdown_flag is a threading.Event object that
        # indicates whether the thread should be terminated.
        self.shutdown_flag = threading.Event()


def glade_client(message: dict) -> None:
    """
    Send message to socket server and close socket.
    """
    sock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
    try:
        sock.connect(('localhost', 10200))
    except ConnectionRefusedError:
        print('Unable to connect to GladeServer')
        return

    try:
        sock.sendall(pickle.dumps(message, protocol=pickle.HIGHEST_PROTOCOL))
    except pickle.UnpicklingError:
        pass
    sock.close()


__all__ = [
    'glade_client',
    'GladeThread',
    'remove_control_characters',
]
