from enum import Enum
from lcconfig import ConsoleSettingsConfig
import os
import sys

csc = ConsoleSettingsConfig().load()
console_config = csc.as_typed_dict('BoxData')
sys.path.append(os.getenv('PROJECT_ROOT'))

try:
    # console depends on glade, so glade will be installed before logcabin
    # but don't crash if celery_init isn't available
    from celery_init import portal_app
    from console_settings import (
        DATETIME_FMT,
    )
except (ModuleNotFoundError, ImportError):
    portal_app = None
    DATETIME_FMT = '%Y-%m-%d %H:%M:%S'

DETECT_HOSTNAME = 'detect-hostname'
DIRECTORY_SERVER = console_config.get('directory_server', None)
if DIRECTORY_SERVER and DIRECTORY_SERVER.lower() == 'none':
    DIRECTORY_SERVER = None

LOGGING = {
    'version': 1,
    'disable_existing_loggers': False,
    'filters': {
        'require_debug_false': {
            '()': 'django.utils.log.RequireDebugFalse',
        }
    },
    'formatters': {
        'default_formatter': {
            'format': "[%(asctime)s] %(levelname)s [%(name)s:%(lineno)s] %(message)s",
            'datefmt': DATETIME_FMT,
        },
    },
    'handlers': {
        'file': {
            'level': 'INFO',
            'class': 'logging.FileHandler',
            'filename': '/var/log/glade/glade.log',
            'formatter': 'default_formatter',
        },
        'console': {
            'class': 'logging.StreamHandler',
            'formatter': 'default_formatter',
        },
    },
    'loggers': {
        'glade': {
            'handlers': ['file'],
            'propagate': True,
            'level': 'INFO',
        },
    },
}


class Source(Enum):

    ARP = 'arp'
    DHCP = 'dhcp'
    ZEROCONF = 'zeroconf'
