import socket
from zeroconf import ServiceBrowser, Zeroconf

from ..utils import (
    glade_client,
    remove_control_characters,
)
from ..settings import Source


class ServiceListener:

    def remove_service(self, zeroconf, type, name):
        print(f"Service {name} removed")

    def add_service(self, zeroconf, type, name):
        """
        Get Workstations and Printers from the network
        """
        if type.startswith('_printer'):
            service_type = 'printer'
        elif type.startswith('_workstation'):
            service_type = 'workstation'
        else:
            return

        info = zeroconf.get_service_info(type, name)
        if not info:
            return

        try:
            hostname = remove_control_characters(info.server.split('.')[0])
        except Exception:
            hostname = 'UNK'

        glade_client({
            'source': Source.ZEROCONF.value,
            'type': service_type,
            'hostname': hostname,
            'mac': '',
            'ip': socket.inet_ntoa(info.addresses[0]),
        })


__all__ = [
    'ServiceListener',
]

if __name__ == '__main__':

    zeroconf = Zeroconf()
    listener = ServiceListener()
    workstations = ServiceBrowser(zeroconf, "_workstation._tcp.local.", listener)
    printers = ServiceBrowser(zeroconf, "_printer._tcp.local.", listener)

    try:
        input("Press enter to exit...\n\n")
    finally:
        zeroconf.close()
