from lcutils import NetworkInfo
import time

from ..utils import (
    glade_client,
    GladeThread,
)
from ..settings import DETECT_HOSTNAME, Source


class ARPTable(GladeThread):
    """
    Launch a thread to monitor ARP table
    """

    def run(self) -> None:

        ni = NetworkInfo()

        while not self.shutdown_flag.is_set():

            # sleep at beginning, to allow other services to process data first
            time.sleep(300)
            arp_table = ni.arp_table()
            lease_table = {lease.ip: lease.host for lease in ni.dhcp_leases()}

            for i, entry in enumerate(arp_table):

                # do another check rather than continue to process
                # what could be a very large arp cache.
                if i and not i % 10:
                    if self.shutdown_flag.is_set():
                        return

                ip = entry['IP address']
                hostname = lease_table.get(ip, '*')
                if not hostname or hostname == '*':
                    # generate unique hostname so it can be cached in GladeServer
                    hostname = f'{DETECT_HOSTNAME}|{ip}'
                else:
                    try:
                        hostname = hostname[:hostname.index('.')]
                    except ValueError:
                        pass

                glade_client({
                    'source': Source.ARP.value,
                    'type': '',
                    'hostname': hostname,
                    'mac': entry['HW address'],
                    'ip': ip,
                })


__all__ = [
    'ARPTable',
]
