from lcutils import get_oui_vendor


APPLE_PLATFORM_MAP = {
    'iPod': 'portablemediaplayer',
    'iPad': 'tablet',
    'iPhone': 'smartphone',
}

VENDOR_MAP = {
    'ingenico': 'pos',
    'ubiquiti networks': 'switchrouter',
    'yealink': 'deskphone',
}


def check_device_type(hostname: str, mac: str, platform: str) -> str:
    """
    Guess device type based on MAC OUI Vendor name.
    """
    vendor = get_oui_vendor(mac=mac).lower()
    if vendor == 'n/a':
        return 'UNK'

    if vendor.startswith('apple'):
        if platform == 'Macintosh':
            if hostname.endswith(('-macbook', '-mbp')):
                return 'laptop'

        return APPLE_PLATFORM_MAP.get(platform, 'UNK')

    for vendor, device_type in VENDOR_MAP.items():
        if vendor in hostname:
            return device_type

    return 'UNK'


__all__ = [
    'check_device_type',
]
