#!/usr/bin/env python
from setuptools import setup, find_packages
import codecs
import os.path
import re


def get_version():
    with open('encipher/__init__.py', 'r') as f:
        line = f.readline()
        match = re.match(r'__version__ = \'([\d\.]+)\'', line)

        if not match:
            raise ImportError("Can't read the version of Encipher")

        version = match.group(1)
        return version


def requirements():
    with open('requirements.txt') as req:
        return [r.strip() for r in req.readlines()]


extras_require = {
    "development": [
        "coverage>=7.6",
        "django-stubs>=5.0",
        "freezegun>=1.5.1",
        "mypy>=1.11",
        "sphinx-rtd-theme>=2.0",
        "sphinx>=7.4",
    ],
}


def fpath(name):
    return os.path.join(os.path.dirname(__file__), name)


def read(fname):
    return codecs.open(fpath(fname), encoding="utf-8").read()


setup(
    name="encipher",
    description="Secure key based authentication for HTTP APIs",
    version=get_version(),
    long_description=read(fpath("README.rst")),
    classifiers=[
        "Development Status :: 5 - Production/Stable",
        "Environment :: Web Environment",
        "Framework :: Django",
        "Intended Audience :: Developers",
        "License :: OSI Approved :: ISC License (ISCL)",
        "Operating System :: Unix",
        "Operating System :: MacOS :: MacOS X",
        "Programming Language :: Python",
        "Programming Language :: Python :: 3",
    ],
    author="Dave Burkholder",
    author_email="dave@compassfoundation.io",
    url="https://code.compassfoundation.io/console-modules/encipher",
    license="ISC",
    packages=find_packages(exclude=['docs', 'sandbox']),
    include_package_data=True,
    install_requires=requirements(),
    extras_require=extras_require,
)
