from datetime import datetime
from django.http import HttpRequest
from typing import NamedTuple, TypedDict, TYPE_CHECKING
from .choices import SUBJECT

if TYPE_CHECKING:
    from sandbox.latchstring.models import User as UserType
    from encipher.tokens import AccessToken
    from uuid import UUID


class ClaimCreds(TypedDict):
    user_cid: str
    email: str


class KeyData(NamedTuple):
    cid: 'UUID'
    kid: str
    key: str
    subject: SUBJECT
    last_used_on: datetime


class VerifiedAuth(NamedTuple):
    user: 'UserType'
    token: 'AccessToken'


class TokenAuthRequest(HttpRequest):
    """
    Add attribute for mypy compatibility.
    """

    _dont_enforce_csrf_checks: bool
