import secrets


class BaseNonceBackend:
    def validate_nonce(self, timestamp: int, nonce: str) -> bool:
        raise NotImplementedError()

    def log_used_nonce(self, timestamp: int, nonce: str) -> None:
        raise NotImplementedError()

    def generate_nonce(self) -> str:
        return secrets.token_urlsafe(nbytes=8)
