# Generated by Django 4.1.4 on 2023-03-28 10:24

import console_base.models.fernet
import console_base.models.fields
import console_base.models.mixins
import console_deps.dirtyfields.dirtyfields
from django.conf import settings
from django.db import migrations, models
from django.contrib.postgres.operations import CITextExtension
import django.utils.timezone
import encipher.fields
import encipher.validators
import sequential_uuids.generators


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        CITextExtension(),
        migrations.CreateModel(
            name="EncryptionKey",
            fields=[
                (
                    "cid",
                    console_base.models.fields.CanonicalIdField(
                        db_index=True,
                        default=sequential_uuids.generators.uuid_time_nextval,
                        help_text="Canonical ID assigned to this record, locally or on external systems. Should not be changed, except to reconcile sync errors.",
                        unique=True,
                    ),
                ),
                ("created", models.DateTimeField(default=django.utils.timezone.now)),
                ("modified", models.DateTimeField(default=django.utils.timezone.now)),
                ("is_active", models.BooleanField(default=True)),
                (
                    "id",
                    console_base.models.fields.UUID6Field(
                        default=sequential_uuids.generators.uuid_time_nextval,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "key",
                    encipher.fields.KeyField(
                        help_text="The user's RSA / Ed25519 / ECDSA public key",
                        validators=[encipher.validators.validate_public_key],
                        verbose_name="Encryption Key",
                    ),
                ),
                (
                    "kid",
                    console_base.models.fields.LCTextField(
                        help_text="Paserk Key ID derived from the Public Key"
                    ),
                ),
                (
                    "private_key",
                    console_base.models.fernet.EncryptedBinaryField(
                        blank=True,
                        help_text="The user's RSA / Ed25519 / ECDSA private key",
                        null=True,
                        verbose_name="Private Key",
                    ),
                ),
                (
                    "name",
                    console_base.models.fields.NameCITextField(verbose_name="Name"),
                ),
                (
                    "last_used_on",
                    models.DateTimeField(
                        blank=True, null=True, verbose_name="Last Used On"
                    ),
                ),
                (
                    "revocation_date",
                    models.DateTimeField(
                        blank=True, null=True, verbose_name="Revocation Date"
                    ),
                ),
                (
                    "status",
                    console_base.models.fields.LCTextField(
                        choices=[
                            ("active", "Active and In Use"),
                            ("expired", "Expired and Inactive"),
                            ("lost", "Revoked - Lost or Stolen Device"),
                            ("replaced", "Revoked - Replaced Device"),
                        ],
                        default="active",
                        verbose_name="Status",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="encryption_keys",
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="User",
                    ),
                ),
            ],
            options={
                "verbose_name": "Encryption Key",
                "verbose_name_plural": "Encryption Keys",
            },
            bases=(
                console_base.models.mixins.FilterFields,
                console_deps.dirtyfields.dirtyfields.DirtyFieldsMixin,
                models.Model,
            ),
        ),
        migrations.AddConstraint(
            model_name='encryptionkey',
            constraint=models.UniqueConstraint(
                condition=models.Q(('revocation_date__isnull', True)),
                fields=('user', 'name'),
                name='unique_key_name_per_user',
            ),
        ),
        migrations.AddConstraint(
            model_name="encryptionkey",
            constraint=models.UniqueConstraint(
                fields=("key",), name="encryption_keys_must_be_unique"
            ),
        ),
        migrations.AddConstraint(
            model_name='encryptionkey',
            constraint=models.UniqueConstraint(
                fields=('kid',), name='public_key_ids_must_be_unique'
            ),
        ),
    ]
