from aspen_crypto.keys import RSAPrivateKey, Ed25519PrivateKey
from django.core.management.base import BaseCommand

TYPE_RSA = "RSA"
TYPE_ED25519 = "Ed25519"
TYPE_CHOICES = [
    TYPE_RSA,
    TYPE_ED25519,
]


class Command(BaseCommand):
    help = "Generate Ed25519 or RSA public / private key pair"

    def add_arguments(self, parser):
        parser.add_argument("-t", "--keytype", choices=TYPE_CHOICES, default=TYPE_RSA)

    def handle(self, *args, keytype=TYPE_ED25519, **options):
        if keytype == TYPE_ED25519:
            private_key = Ed25519PrivateKey.generate()
        else:
            private_key = RSAPrivateKey.generate()

        self.stdout.write(
            f'\nPublic Key:\n{private_key.public_key.as_pem.decode()}\n'
            f'\nPrivate Key:\n{private_key.as_pem.decode()}\n\n'
        )
