from django.db.models import TextChoices
from django.utils.translation import gettext_lazy as tr
from lcrequests.typehints import Subject
from console_base.choices import LCTextChoicesMixin


class STATUS(LCTextChoicesMixin, TextChoices):
    active = 'active', tr('Active and In Use')
    expired = 'expired', tr('Expired and Inactive')
    lost = 'lost', tr('Revoked - Lost or Stolen Device')
    replaced = 'replaced', tr('Revoked - Replaced Device')
    retired = 'retired', tr('Retired - No longer needed')


class SUBJECT(LCTextChoicesMixin, TextChoices):
    """
    Subjects must be defined when using Paseto Tokens.
    The subject must correspond with the source of the
    API call.

    For example, tokens with a DrawBridge subject must
    originate from a DrawBridge system.
    """

    Any = 'any', tr('API Calls from any source')
    Aspen = Subject.Aspen.value, tr('API Calls from Aspen')
    Beacon = Subject.Beacon.value, tr('API Calls from Beacon')
    Clavis = Subject.Clavis.value, tr('API Calls from Clavis')
    Clarion = Subject.Clarion.value, tr('API Calls from Clarion')
    DrawBridge = Subject.DrawBridge.value, tr('API Calls from DrawBridge')
    Daystar = Subject.Daystar.value, tr('API Calls from Daystar')
    MapleLeaf = Subject.MapleLeaf.value, tr('API Calls from MapleLeaf')
    Umbrella = Subject.Umbrella.value, tr('API Calls from Odoo Umbrella')
    VisionMarket = Subject.VisionMarket.value, tr('API Calls from VisionMarket')
    Desk = Subject.Desk.value, tr('API Calls from Devices')
