from django_filters import rest_framework as filters
from console_base.filters import (
    DateFilter,
    NameFilter,
)

from encipher.models import EncryptionKey


# ---------------------------------------------------------------------------
class EncryptionKeyFilter(NameFilter):
    key = filters.CharFilter(field_name='key', lookup_expr='exact')
    cid = filters.CharFilter(field_name='cid', lookup_expr='exact')
    kid = filters.CharFilter(field_name='kid', lookup_expr='exact')
    status = filters.CharFilter(field_name='status', lookup_expr='exact')
    user = filters.UUIDFilter(field_name='user__cid', lookup_expr='exact')

    class Meta(DateFilter.Meta):
        model = EncryptionKey
        fields = DateFilter.Meta.fields + (
            'key',
            'cid',
            'kid',
            'status',
            'user',
        )


__all__ = [
    'EncryptionKeyFilter',
]
