__version__ = '0.5.2'
from django.conf import settings
import copy

# Default settings. Override using a dictionary named ENCIPHER in Django's settings.py.
default_settings = {
    # Auth method searched for in the prefix of the Authentication header.
    # Similar to ``Bearer`` or ``Basic``.
    "AUTH_METHOD": "Paseto",
    # Auth method to be used when PublicKey for verifying Paseto is pre-generated and in
    # use by multiple clients.
    "PINNED_AUTH_METHOD": "Pinned_Paseto",
    # Seconds of clock-drift to tolerate when verifying the authenticity of a Paseto Token.
    "TIMESTAMP_TOLERANCE": 20,  # Seconds
    # How often to update last_used_on date of Paseto Token.
    # Keys used oftener than this will not get updated to save database writes.
    "LAST_USED_INTERVAL": 15,  # minutes
    # Class used to store and validate nonces
    "NONCE_BACKEND": "encipher.nonce.django.DjangoCacheNonceBackend",
    # Repository class used to fetch users by their username
    "USER_REPOSITORY": "encipher.repos.django.DjangoUserRepository",
    # List of repository classes used to fetch public keys for a user
    "PUBLIC_KEY_REPOSITORIES": [
        "encipher.repos.django.DjangoPublicKeyListRepository",
    ],
}


def get_setting(name: str):
    try:
        return settings.ENCIPHER[name]
    except (AttributeError, KeyError):
        pass

    _settings = copy.deepcopy(default_settings)
    _settings.update(getattr(settings, "ENCIPHER", {}))
    settings.ENCIPHER = _settings

    return _settings[name]
