import logging
from lcconfig import LCConfigParser
from system_env.environment import setup_portal_environment

portal_env = setup_portal_environment()

logging.basicConfig(
    filename="/var/log/dalmatian/dalmatian.log",
    level=logging.INFO,
    format="%(asctime)s %(levelname)s %(message)s",
)

DALMATIAN_DIR = portal_env.get('DALMATIAN_DIR')
MAXMIND_DIR = f'{DALMATIAN_DIR}/maxmind'
PORTAL_ROOT = portal_env.get('PROJECT_ROOT')
SUBSCRIPTIONS_DIR = f'{DALMATIAN_DIR}/subscriptions'
IS_DRAWBRIDGE_OS = portal_env.get('IS_DRAWBRIDGE_OS')

DALMATIAN_CONFIG_FILE = '/etc/dalmatian/dalmatian.conf'
DALMATIAN_DOMAINS_DIR = '/etc/dalmatian/domains'

CONF_DIR = f'{DALMATIAN_DIR}/config'
REDWOOD_CATEGORY_DIR = portal_env.get('REDWOOD_CATEGORY_DIR', '/etc/redwood/categories')
IPSET_DIR = f'{portal_env.get("FIREWALL_DIR")}/ipsets/dalmatian'
RPZ_DIR = f'{portal_env.get("DNS_DIR")}/rpz/dalmatian'

DEFAULT_PUBLISHER_URL = 'whitespire.compassfoundation.io'


# ----------------------------------------------------------------------------
class DalmatianConfig(LCConfigParser):
    main_section = 'DALMATIAN'
    config_settings = f'{CONF_DIR}/settings.conf'
    persist_file = f'{CONF_DIR}/settings.conf'


__all__ = (
    'logging',
    'DEFAULT_PUBLISHER_URL',
    'IPSET_DIR',
    'IS_DRAWBRIDGE_OS',
    'DALMATIAN_DIR',
    'PORTAL_ROOT',
    'REDWOOD_CATEGORY_DIR',
    'RPZ_DIR',
    'SUBSCRIPTIONS_DIR',
    'DalmatianConfig',
)
