from invoke import task
from lchttp import yaml_load
from pathlib import Path
from dalmatian.settings import logging, SUBSCRIPTIONS_DIR

logger = logging.getLogger(__name__)


@task
def show(ctx):
    """
    List all available subscriptions, and the supported services.
    """
    for subscription in Path(SUBSCRIPTIONS_DIR).iterdir():

        try:
            with open(f'{subscription}/settings.yml') as sf:
                settings = yaml_load(sf)
        except FileNotFoundError:
            print(f'\nNo subscriptions enabled for {subscription}\n')
            continue

        print(f'\n{subscription.name}: {settings["description"]}')
        for key, service in (
            ('rpz', 'DNS RPZ'),
            ('ipset', 'Firewall IPset'),
            ('redwood', 'Redwood Category'),
            ('maxmind', 'Maxmind DB'),
        ):
            print(f'{service} - {settings[key]}')
