from invoke import task
from lchttp import yaml_load
import os
from pathlib import Path
from dalmatian.settings import logging, SUBSCRIPTIONS_DIR, MAXMIND_DIR

from netaddr import IPSet
from dalmatian.packages.mmdb_writer import MMDBWriter

from ..config_files import download_url

logger = logging.getLogger(__name__)


@task
def generate(ctx):
    """
    Generate MaxMind Databases from IP Addresses & Networks in Subscriptions.
    """

    if not os.path.exists(MAXMIND_DIR):
        os.makedirs(MAXMIND_DIR)

    entries = 0
    for subscription in Path(SUBSCRIPTIONS_DIR).iterdir():

        try:
            with open(f'{subscription}/settings.yml') as sf:
                settings = yaml_load(sf)
        except FileNotFoundError:
            print(f'\nNo subscriptions enabled for {subscription}\n')
            continue

        if settings['maxmind']:
            writer = MMDBWriter(
                database_type=settings['maxmind_db_type'],
                description=settings['description'],
            )

            for url in settings['urls']:
                resp = download_url(settings['name'], url, {})

                file_name = url.split('/').pop().split('.')[0]
                try:
                    maxmind_data = settings['maxmind_data'][file_name]
                except KeyError:
                    maxmind_data = {}

                ip_addresses = [
                    address for address in resp.decode().split('\n')
                    if address and not address.startswith('#')
                ]
                maxmind_data.update({
                    'category': file_name,
                    'genre': subscription.name,
                })
                writer.insert_network(IPSet(ip_addresses), maxmind_data)
                entries += len(ip_addresses)

            writer.to_db_file(f'{MAXMIND_DIR}/{settings["name"]}.mmdb')

            print(f'Inserted {entries} IPSets into {settings["name"]}')
