# Dalmatian

Named for pet and watchdog beloved by the firefighters. Dalmatian in this context maintains patterns
for Response Policy Zones (RPZ), IPsets and Redwood category files for greater.


### Command-line Usage

All available commands and a short help text can be listed via `damlatian --list`.

```bash
[root@system ~]# dalmatian --list
Subcommands:

  subscriptions.show   List all available subscriptions, and the supported services.
  update.publisher     Update all upstream subscriptions to this machine for serving
  update.pubsub        Process both the Publisher and Subscriber updates
  update.subscriber    Pull updates from Publisher for all RPZ Zones, IPSets and Redwood Categories.
```


### Publisher

The Dalmatian Publisher downloads files from upstream providers such as [firehol](https://iplists.firehol.org/)
and generates config files compatible for RPZs, IPsets and Redwood categories, as defined in each
subscription's `settings.yml` file.

To make a system a Publisher:

A. Define the config file  `/opt/sap/dalmatian/config/settings.conf` with at least the following contents:

```
[DALMATIAN]
is_publisher=True
```

B. Configure the `rpz` and `ipset` Rsync server settings in `/etc/rsyncd.conf`

```
[rpz]
    comment = Response Policy Zones
    path = /opt/sap/powerdns/rpz/dalmatian/
    read only = false
    list = no
    uid = root
    gid = root
    auth users = rpz
    secrets file = /etc/rsyncd.secrets

[ipset]
    comment = Response Policy Zones
    path = /opt/sap/firewall/ipsets/dalmatian
    read only = false
    list = no
    uid = root
    gid = root
    auth users = rpz
    secrets file = /etc/rsyncd.secrets
```

Add the `rpz` user & password to the `/etc/rsyncd.secrets` file:

```bash
echo "rpz:<rsync-server-password>" >> /etc/rsyncd.secrets
```

### Subscriber
Installing `dalmatian` on a Security Appliance automatically makes that system a Subscriber, unless
configured as a Publisher above. To customize the Publisher server, define the config file in 
`/opt/sap/dalmatian/config/settings.conf` with at least the following contents:

```
[DALMATIAN]
publisher_url=<hostname>
password_file=/path/to/rsync/password/secret.txt
```

Add rsync server password to `password_file`

```bash
echo "<rsync-server-password>" >> /path/to/rsync/password/secret.txt
```

### Update Schedule
Add an hourly cron job to run Publisher or Subscriber update script.

```bash
15 * * * * /usr/bin/dalmatian update.subscriber &> /dev/null
```

### Console Activation

Login to the Log Cabin console to activate the RPZs and IPSets in the DNS Firewall module. 
The Dalmatian subscriptions will not take affect until this is done.
