from invoke import Program, Collection
from invoke.config import Config, merge_dicts
from dalmatian.cli import tasks
from dalmatian import __version__


class DalmatianConfig(Config):
    prefix = 'dalmatian'

    @staticmethod
    def global_defaults():
        their_defaults = Config.global_defaults()
        my_defaults = {
            'run': {
                'echo': True,
            },
        }
        return merge_dicts(their_defaults, my_defaults)


program = Program(
    version=__version__,
    config_class=DalmatianConfig,
    namespace=Collection.from_module(tasks),
)
