import logging
from pyzabbix import ZabbixMetric, ZabbixSender
import socket
from pathlib import Path
from typing import Iterable

logger = logging.getLogger(__name__)


def zabbix(packets: Iterable[tuple], key=None):
    """
    Send metrics back to Zabbix server.
    """
    zabbix_key = key if key else socket.gethostname()

    packet = [ZabbixMetric(zabbix_key, key, str(value)) for key, value in packets]

    dbos_location = '/run/zabbix/zabbix-agent2.conf'
    if Path(dbos_location).exists():
        use_config = dbos_location
    elif Path('/etc/zabbix/zabbix_agent2.conf').exists():
        use_config = '/etc/zabbix/zabbix_agent2.conf'
    else:
        use_config = '/etc/zabbix/zabbix_agentd.conf'

    try:
        ZabbixSender(use_config=use_config).send(packet)
    except Exception as e:
        logger.exception(f'Unable to send Zabbix packets: {e}')
        print(f'Unable to send Zabbix packets: {e}')


__all__ = [
    'zabbix',
]
