from django.test import SimpleTestCase

from console_base.utils.urls import trimmed_url


# -------------------------------------------------------------------------
class TestUrlTrimming(SimpleTestCase):
    def test_trimmed_urls(self):
        for original, trimmed in (
            (
                'https://TomCat.io/tom/cat/?pussy=willow&box=car#happy=harry',
                'https://tomcat.io/tom/cat/',
            ),
            ('https://constable.io/#happy=harry', 'https://constable.io/'),
            ('https://boxcar.io/tom/cat/', 'https://boxcar.io/tom/cat/'),
            ('http://piglet.io/', 'https://piglet.io/'),
            ('http://piglet.io?winnie=pooh', 'https://piglet.io'),
            ('ipfs://piglet.io?winnie=pooh', 'ipfs://piglet.io'),
            ('ipns://piglet.io?winnie=pooh', 'ipns://piglet.io'),
            ('dweb://piglet.io?winnie=pooh', 'dweb://piglet.io'),
        ):
            self.assertEqual(trimmed_url(original), trimmed)
