try:
    from yaml.cyaml import CSafeLoader as Loader, CSafeDumper as Dumper
except ImportError:
    from yaml import SafeLoader as Loader, SafeDumper as Dumper  # type: ignore

import yaml


def yaml_safe_dump(data, stream, **kwargs):
    """
    Wrapper function for dumping python values to yaml,
    using C libraries for speed, if available.
    """
    return yaml.dump(data, stream, Dumper=Dumper, **kwargs)


def yaml_safe_load(data):
    """
    Wrapper function for loading python values from yaml,
    using C libraries for speed, if available.
    """
    return yaml.load(data, Loader=Loader)


__all__ = (
    'yaml_safe_dump',
    'yaml_safe_load',
)
