from pathlib import PosixPath
from django.core.exceptions import ValidationError


# ---------------------------------------------------------------------------
def validate_file_path(value: str) -> None:
    """
    Validate that the file exists on the local file system.
    """

    if not PosixPath(value).is_file():
        raise ValidationError(f'{value} does not exist on the file system')


# ---------------------------------------------------------------------------
def validate_directory(value: str) -> None:
    """
    Validate that the director exists on the local file system.
    """

    if not PosixPath(value).is_dir():
        raise ValidationError(f'{value} does not exist on the file system')


__all__ = (
    'validate_file_path',
    'validate_directory',
)
