#!/usr/bin/env python3
from setuptools import setup

from console_base import __version__ as VERSION


def read_me():
    with open('README.md') as read:
        return read.read()


def requirements():
    with open('requirements.txt') as req:
        print([r.strip() for r in req.readlines()])
        return [r.strip() for r in req.readlines()]


setup(
    name='console_base',
    version=VERSION,
    description="Base module with Python Code common Compass Consoles written in Django.",
    long_description=read_me(),
    author='Dave Burkholder',
    author_email='dave@compassfoundation.io',
    url='https://code.compassfoundation.io/console-modules/console_base',
    packages=['console_base'],
    include_package_data=True,
    install_requires=requirements(),
    zip_safe=False,
    keywords='console',
    classifiers=[
        'Development Status :: 5 - Production/Stable',
        'Framework :: Django',
        'Framework :: Django :: 3.0',
        'Intended Audience :: Developers',
        'Operating System :: POSIX :: Linux',
        'Natural Language :: English',
        'Programming Language :: Python :: 3.11',
        'Programming Language :: Python :: 3.12',
    ],
)
