# type: ignore
"""
Log Cabin branding/theme settings that should be available in every template
"""

from typing import NamedTuple


class Icons(NamedTuple):
    ADDRESSCARD = 'fas fa-address-card'
    ANGLEDOWN = 'fas fa-angle-down'
    ANGLEDOUBLEDOWN = 'fas fa-angle-double-down'
    ANGLEUP = 'fas fa-angle-up'
    ANGLEDOUBLEUP = 'fas fa-angle-double-up'
    ARROW_CIRCLE_DOWN = 'fas fa-arrow-a-user-friendsalt-circle-down'
    ARROW_CIRCLE_LEFT = 'fas fa-arrow-alt-circle-left'
    ARROW_CIRCLE_RIGHT = 'fas fa-arrow-alt-circle-right'
    ARROW_CIRCLE_UP = 'fas fa-arrow-alt-circle-up'
    ARROW_LEFT = 'fa fa-arrow-left'
    ARROW_RIGHT = 'fa fa-arrow-right'
    ARROW_X = 'fas fa-arrows-alt'
    BOLT = 'fas fa-bolt'
    BOOK = 'fas fa-book'
    BOOKOPEN = 'fas fa-book-open'
    BOOKREADER = 'fas fa-book-reader'
    BAN = 'fas fa-ban'
    CID = 'fas fa-fingerprint'
    CLOCKEDSCHEDULE = 'fas fa-clock'
    CHEVRON_LEFT = 'fas fa-chevron-left'
    CHEVRON_RIGHT = 'fas fa-chevron-right'
    CRONTABSCHEDULE = 'fas fa-stopwatch'
    CODE = 'fa fa-code'
    COG = 'fa fa-cog'
    INTERVALSCHEDULE = 'fas fa-hourglass-half'
    SOLARSCHEDULE = 'fas fa-sun'
    CONNECTIONS = 'fab fa-connectdevelop'
    CLONE = 'fa fa-clone'
    CPU = 'fas fa-microchip'
    DATABASE = 'fas fa-database'
    EMAIL = 'fas fa-at'
    ENVELOPE = 'fa fa-envelope'
    ELLIPSIS = 'fa fa-ellipsis-v'
    ERASED = 'fas fa-eraser'
    ENCRYPTION = 'fas fa-shield-alt'
    EXCLAMATION = 'fas fa-exclamation-triangle'
    TLS = 'fas fa-shield-alt'
    SHREDDED = 'fas fa-cut'
    BACKUPS = 'fas fa-tools'
    BARS = 'fa fa-bars'
    BULLSEYE = 'fa fa-bullseye'
    CARET_SQUARE_R = 'fas fa-caret-square-right'
    CARET_DOWN = 'fa fa-caret-down'
    CARET_UP = 'fa fa-caret-up'
    CHECK = 'fas fa-check'
    CHECK_CIRCLE = 'fas fa-check-circle'
    CHECK_CIRCLE_R = 'far fa-check-circle'
    CHECK_SQUARE = 'fa fa-check-square'
    CLIPBOARD = 'fas fa-clipboard'
    COLUMNS = 'fas fa-columns'
    CROP = 'fas fa-crop-alt'
    DASHBOARD = 'fas fa-tachometer-alt'
    DELETE = 'fa fa-trash'
    DOWNLOAD = 'fas fa-cloud-download-alt'
    EDIT = 'fa fa-edit'
    FILTER = 'fas fa-filter'
    FRIENDS = 'fas fa-user-friends'
    HAND_WARNING = 'fas fa-hand-paper'
    HARDDRIVE = 'fas fa-hdd'
    HELP = 'fas fa-info-circle'
    QUESTION_CIRCLE = 'fas fa-question-circle'
    HISTORY = 'fas fa-history'
    KEY = 'fas fa-key'
    LINK = 'fas fa-external-link-alt'
    LIST = 'fa fa-list'
    LIST_UL = 'fas fa-list-ul'
    LOGIN = 'fas fa-sign-in-alt'
    LOGOUT = 'fas fa-sign-out-alt'
    MEMORY = 'fas fa-memory'
    MERGE = 'fas fa-object-group'
    MINUS_CIRCLE = 'fas fa-minus-circle'
    MINUS_SQUARE = 'fas fa-minus-square'
    PACKET = 'fas fa-pallet'
    PROTOCOLS = 'fas fa-boxes'
    PASSWORD = 'fa fa-key'
    PAGETITLE = 'fas fa-heading'
    PAPER_PLANE = 'fa fa-paper-plane'
    PERMISSIONS = 'fa fa-key'
    PHONENUMBER = 'fas fa-phone-alt'
    PHOTOVIDEO = 'fas fa-photo-video'
    PLAY_CIRCLE = 'fas fa-play-circle'
    PLUS = 'fa fa-plus'
    PLUS_CIRCLE = 'fas fa-plus-circle'
    PLUS_SQUARE = 'fas fa-plus-square'
    RECYCLE = 'fa fa-recycle'
    ROBOT = 'fas fa-robot'
    SAVE = 'far fa-save'
    SEARCH = 'fas fa-search-plus'
    SESSION = 'fas fa-sign-in-alt'
    SIGNIN = 'fas fa-sign-in-alt'
    SIGNOUT = 'fas fa-sign-out-alt'
    SETTINGS = 'fas fa-tools'
    SHARE = 'fas fa-share'
    SORT = 'fas fa-sort'
    SPINNER = 'fas fa-spinner'
    SSL = 'fab fa-expeditedssl'
    STREAM = 'fas fa-stream'
    TASK = 'fas fa-dolly'
    TOGGLE_OFF = 'fas fa-toggle-off'
    TOGGLE_ON = 'fas fa-toggle-on'
    UPDATE = 'fas fa-pencil-alt'
    UPLOAD = 'fas fa-cloud-upload-alt'

    # Platform CSS Icons
    APPSTORE = 'fab fa-app-store'
    ANDROID = 'fab fa-android'
    APPLE = 'fab fa-apple'
    BLACKBERRY = 'fab fa-blackberry'
    FIREFOX = 'fab fa-firefox'
    IOS = 'fab fa-app-store-ios'
    WINDOWS = 'fab fa-windows'

    # Device type Icons
    INFO = 'fas fa-info-circle'
    CAMERA = 'fas fa-camera'
    DESKPHONE = 'fas fa-phone'
    GPS = 'fas fa-map-marked-alt'
    MEDIAPLAYER = 'fas fa-record-vinyl'
    GENERALDEVICE = 'fas fa-microchip'
    DESKTOP = 'fas fa-desktop'
    LAPTOP = 'fas fa-laptop'
    LINUX = 'fab fa-linux'
    PRINTER = 'fas fa-print'
    POS = 'fas fa-cart-plus'
    ROUTER = 'fas fa-shield-alt'
    SMARTPHONE = 'fas fa-mobile'
    TABLET = 'fas fa-tablet'
    SMARTDISPLAY = 'fas fa-tv'
    WIFI = 'fas fa-wifi'

    # Common Model icons
    APP = 'fas fa-cogs'
    APPLIANCE = 'fa fa-server'
    APPLICATION = 'fas fa-cogs'
    ARCHIVE = 'fas fa-chart-area'
    BOOKMARK = 'fas fa-bookmark'
    BRAND = 'fa fa-registered'
    CATEGORY = 'fa fa-cube'
    COMPANY = 'fa fa-university'
    CONTACTS = 'fas fa-users'
    DEVICE = 'fa fa-tablet'
    DEVICEMODEL = 'fa fa-tablet'
    EVENT = 'fas fa-stream'
    GROUP = 'fas fa-user-lock'
    GENRE = 'fa fa-cubes'
    HTMLPAGE = 'fab fa-html5'
    NETWORK = 'fa fa-network-wired'
    NETWORKINTERFACE = 'fa fa-network-wired'
    OPERATINGSYSTEM = 'far fa-dot-circle'
    PERMISSION = 'fas fa-user-lock'
    POLICY = 'far fa-hand-peace'
    PREFERENCE = 'fas fa-check-double'
    PRESET = 'fa fa-magic'
    REPORT = 'fas fa-chart-area'
    SCANNERS = 'fas fa-quidditch'
    SCHEDULE = 'fa fa-calendar'
    SERVICE = 'fa fa-rocket'
    SYNCBATCH = 'fa fa-sync-alt'
    SYNCEDRECORD = 'fas fa-exchange-alt'
    SYNCSERVER = 'fas fa-database'
    SYNCTABLE = 'fa fa-table'
    TEMPLATE = 'far fa-file-alt'
    TICKET = 'fa fa-life-ring'
    USER = 'fas fa-user'
    USER_CHECK = 'fas fa-user-check'
    USERAGENT = 'fa fa-strikethrough'


ICONS = Icons

__all__ = (
    'Icons',
    'ICONS',
)
