from django.db import InterfaceError, OperationalError
from django.core.exceptions import DisallowedHost, DisallowedRedirect
from django.http import UnreadablePostError
from rest_framework.exceptions import PermissionDenied


def skip_disallowed_host_errors(record):
    """
    Filter out DisallowedHost and DisallowedRedirect from the admin emails.
    """
    if record.exc_info:
        _, exc_value = record.exc_info[:2]
        if isinstance(exc_value, (DisallowedHost, DisallowedRedirect)):
            return False

    return True


def skip_unreadable_posts(record):
    """
    Filter out UnreadablePostError from the admin emails.
    """
    if record.exc_info:
        _, exc_value = record.exc_info[:2]
        if isinstance(exc_value, UnreadablePostError):
            return False

    return True


def skip_runtime_operational_errors(record):
    """
    Filter out InterfaceError, OperationalError and RuntimeError from the admin emails.
    """
    if record.exc_info:
        _, exc_value = record.exc_info[:2]
        if isinstance(exc_value, (InterfaceError, OperationalError, RuntimeError)):
            return False

    return True


def skip_permission_denied_errors(record):
    """
    Filter out PermissionDenied from the admin emails.
    """
    if record.exc_info:
        _, exc_value = record.exc_info[:2]
        if isinstance(exc_value, PermissionDenied):
            return False

    return True
