from typing import Any

from django.core.exceptions import ValidationError

EXISTING_RECORD_CID_KEY = 'existing_record_cid'


# ---------------------------------------------------------------------------
class UniqueConstraintValidationError(ValidationError):
    """
    Extend standard ValidationError class to track data for syncing:
      * The existing Canonical ID record with which the new record conflicts
    """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        self.existing_record_cid = kwargs.pop(EXISTING_RECORD_CID_KEY, None)
        super().__init__(*args, **kwargs)

    def __repr__(self) -> str:
        return f"{self.__class__.__name__}({self})"
