from django.db.models import TextChoices


class LCIntegerChoicesMixin:
    """
    Use mixin to retain compatibility with Mypy type checks.
    """

    @classmethod
    def get_value(cls, value: int) -> int | None:
        try:
            return cls.__dict__['_value2member_map_'][value]
        except KeyError:
            pass

    @classmethod
    def label_from_value(cls, value: int) -> str:
        try:
            return cls.__dict__['_value2member_map_'][value].label
        except KeyError:
            return ''


class LCTextChoicesMixin:
    """
    Use mixin to retain compatibility with Mypy type checks.
    """

    @classmethod
    def get_value(cls, value: str) -> str:
        try:
            return cls.__dict__['_value2member_map_'][value]
        except KeyError:
            return ''

    @classmethod
    def label_from_value(cls, value: str) -> str:
        try:
            return cls.__dict__['_value2member_map_'][value].label
        except KeyError:
            return ''


# ---------------------------------------------------------------------------
class CSS(LCTextChoicesMixin, TextChoices):
    """
    Bootstrap CSS Class base names
    """

    Danger = 'danger', 'danger'
    Dark = 'dark', 'dark'
    Default = 'default', 'default'
    Info = 'info', 'info'
    Light = 'light', 'light'
    Primary = 'primary', 'primary'
    Secondary = 'secondary', 'secondary'
    Success = 'success', 'success'
    Transparent = 'transparent', 'transparent'
    Warning = 'warning', 'warning'
    White = 'white', 'white'
