from django.utils.translation import gettext_lazy as tr
from django.apps import AppConfig

from netfields.lookups import (
    EndsWith,
    Family,
    IEndsWith,
    IRegex,
    IStartsWith,
    NetContained,
    NetContainedOrEqual,
    NetContains,
    NetContainsOrEquals,
    NetOverlaps,
    Prefixlen,
    Regex,
    StartsWith,
    HostMatches,
)


class ConsoleBaseConfig(AppConfig):
    name = 'console_base'
    verbose_name = tr('Console Base')

    def ready(self):
        from . import signals
        from .models.fields import IP4RangeAddressField

        IP4RangeAddressField.register_lookup(EndsWith)
        IP4RangeAddressField.register_lookup(IEndsWith)
        IP4RangeAddressField.register_lookup(StartsWith)
        IP4RangeAddressField.register_lookup(IStartsWith)
        IP4RangeAddressField.register_lookup(Regex)
        IP4RangeAddressField.register_lookup(IRegex)
        IP4RangeAddressField.register_lookup(NetContained)
        IP4RangeAddressField.register_lookup(NetContains)
        IP4RangeAddressField.register_lookup(NetContainedOrEqual)
        IP4RangeAddressField.register_lookup(NetContainsOrEquals)
        IP4RangeAddressField.register_lookup(NetOverlaps)
        IP4RangeAddressField.register_lookup(Family)
        IP4RangeAddressField.register_lookup(Prefixlen)
        IP4RangeAddressField.register_lookup(HostMatches)
