from django.core.exceptions import (
    NON_FIELD_ERRORS,
    ValidationError as DjangoValidationError,
)

from rest_framework.exceptions import ValidationError as DRFValidationError
from rest_framework.views import exception_handler as drf_exception_handler


def exception_handler(exc, context):
    """
    rest_framework refuses to call model's `clean` method, so errors
    caught at `save` create 500 errors. Catch those validation errors
    and reraise them as rest_framework's ValidationError.

    Taken from https://gist.github.com/twidi/9d55486c36b6a51bdcb05ce3a763e79f
    """
    if isinstance(exc, DjangoValidationError):
        try:
            exc = DRFValidationError(detail=exc.message_dict)
        except AttributeError:
            exc = DRFValidationError(detail={NON_FIELD_ERRORS: exc.messages})

    return drf_exception_handler(exc, context)
