from django.db.models import CharField, IntegerField, TextField, ForeignKey, Lookup


class NotEqual(Lookup):
    """
    Add
    """

    lookup_name = "ne"

    def as_sql(self, compiler, connection):
        lhs, lhs_params = self.process_lhs(compiler, connection)
        rhs, rhs_params = self.process_rhs(compiler, connection)
        params = lhs_params + rhs_params
        return f"{lhs} <> {rhs}", params


CharField.register_lookup(NotEqual)
ForeignKey.register_lookup(NotEqual)
IntegerField.register_lookup(NotEqual)
TextField.register_lookup(NotEqual)
