from socket import getaddrinfo, SOCK_STREAM


def dns_lookup(hostname: str, port: int | None = 0) -> list[str | int]:
    """
    Return all the IP addresses that the hostname resolves to.
    """
    if not port:
        port = 443

    try:
        return list(map(lambda x: x[4][0], getaddrinfo(f'{hostname}.', port, type=SOCK_STREAM)))
    except OSError:
        return []
