"""
Base DRF views for Console API so that
customizations can consistently and quickly be
deployed throughout the entire application.
"""

from typing import TYPE_CHECKING
from rest_framework.views import APIView

UrlMixinBase = APIView if TYPE_CHECKING else object


# ---------------------------------------------------------------------------
class UrlMixin(UrlMixinBase):  # type: ignore
    @property
    def url_name(self) -> str:
        return self.request.resolver_match.url_name


# ---------------------------------------------------------------------------
class LCAPIView(UrlMixin, APIView):
    """
    Base APIView for the Console
    """

    pass


__all__ = (
    'LCAPIView',
    'UrlMixin',
)
