from rest_framework.routers import (
    APIRootView,
    BaseRouter,
    DefaultRouter,
    SimpleRouter,
)


# ---------------------------------------------------------------------------
class LCBaseRouter(BaseRouter):
    pass


# ---------------------------------------------------------------------------
class LCDefaultRouter(DefaultRouter):
    """
    Extends `DefaultRouter` class to add a method for extending url routes from another router.
    https://stackoverflow.com/questions/31483282/django-rest-framework-combining-routers-from-different-apps/40904241#40904241
    """

    root_view_name = 'Console Root'

    def extend(self, router):
        """
        Extend the routes with url routes of the passed in router.

        Args:
             router: SimpleRouter instance containing route definitions.
        """
        self.registry.extend(router.registry)


# ---------------------------------------------------------------------------
class LCSimpleRouter(SimpleRouter):
    pass


# ---------------------------------------------------------------------------
class LCAPIRootView(APIRootView):
    pass


__all__ = (
    'LCBaseRouter',
    'LCDefaultRouter',
    'LCSimpleRouter',
    'LCAPIRootView',
)
