from rest_framework import status
from rest_framework.exceptions import APIException


class DataIntegrityException(APIException):
    """
    Use to catch DatabaseErrors which return
    status 500 and swap with status 409.

    This way we can give helpful information
    to the user, to recover from their mistake.
    """

    status_code = status.HTTP_409_CONFLICT
    default_detail = 'Data integrity violation'
    default_code = 'invalid'


__all__ = [
    'DataIntegrityException',
]
