from django.db.models import DateTimeField, DateField, Func, UUIDField


class SequentialUUID(Func):
    """
    Use sequential-uuids postgres extension from
    https://github.com/tvondra/sequential-uuids
    """

    template = 'UUID_TIME_NEXTVAL()'
    output_field = UUIDField()


class TimeHashToDate(Func):
    """
    Extract date from timehash field.

    20240902
    20240902-8dcfa68a4

          to_timestamp
    ------------------------
     2024-09-02
    """

    output_field = DateField()
    template = "CAST(SPLIT_PART(%(expressions)s, '_', 1) AS date)"


class TimeHashToDatetime(Func):
    """
    Extract datetime from timehash field.

    240902T2115
    240902T2115-8dcfa68a4

          to_timestamp
    ------------------------
     2024-09-02 21:15:01-04
    """

    output_field = DateTimeField()
    template = "CAST(SPLIT_PART(%(expressions)s, '_', 1) AS timestamptz)"


__all__ = (
    'SequentialUUID',
    'TimeHashToDate',
    'TimeHashToDatetime',
)
