from .globals import request_context

from django.conf import settings
from django.utils.deprecation import MiddlewareMixin

try:
    SKIP_MIDDLEWARE_URLS = settings.SKIP_MIDDLEWARE_URLS
except AttributeError:
    SKIP_MIDDLEWARE_URLS = ()


class RequestContextMiddleware(MiddlewareMixin):
    """
    Set global context on URLs that aren't skipped.
    """

    def process_request(self, request):
        if request.path not in SKIP_MIDDLEWARE_URLS:
            request_context.init_by_request(request)

    def process_response(self, request, response):
        if request.path not in SKIP_MIDDLEWARE_URLS:
            request_context.clear()
        return response
