from typing import Any

from django.conf import settings
from drf_spectacular.extensions import OpenApiAuthenticationExtension
from drf_spectacular.plumbing import build_bearer_security_scheme_object


class TokenAuthenticationScheme(OpenApiAuthenticationExtension):  # type: ignore[no-untyped-call]
    target_class = 'console_base.authentication.LCTokenAuthentication'
    name = 'console-token-auth'

    def get_security_definition(self, auto_schema: Any) -> dict:
        return build_bearer_security_scheme_object(  # type: ignore[no-untyped-call]
            header_name='Authorization',
            token_prefix=settings.AUTH_HEADER_NAME,
        )


__all__ = [
    'TokenAuthenticationScheme',
]
