"""
Base DRF generics for Console API so that
customizations can consistently and quickly be
deployed throughout the entire application.
"""

from rest_framework.generics import (
    GenericAPIView,
    CreateAPIView,
    ListAPIView,
    RetrieveAPIView,
    DestroyAPIView,
    UpdateAPIView,
    ListCreateAPIView,
    RetrieveDestroyAPIView,
    RetrieveUpdateAPIView,
    RetrieveUpdateDestroyAPIView,
)


# ---------------------------------------------------------------------------
class LCGenericAPIView(GenericAPIView):
    pass


# ---------------------------------------------------------------------------
class LCCreateAPIView(CreateAPIView):
    pass


# ---------------------------------------------------------------------------
class LCListAPIView(ListAPIView):
    pass


# ---------------------------------------------------------------------------
class LCRetrieveAPIView(RetrieveAPIView):
    pass


# ---------------------------------------------------------------------------
class LCDestroyAPIView(DestroyAPIView):
    pass


# ---------------------------------------------------------------------------
class LCUpdateAPIView(UpdateAPIView):
    pass


# ---------------------------------------------------------------------------
class LCRetrieveDestroyAPIView(RetrieveDestroyAPIView):
    pass


# ---------------------------------------------------------------------------
class LCRetrieveUpdateAPIView(RetrieveUpdateAPIView):
    pass


# ---------------------------------------------------------------------------
class LCListCreateAPIView(ListCreateAPIView):
    pass


# ---------------------------------------------------------------------------
class LCRetrieveUpdateDestroyAPIView(RetrieveUpdateDestroyAPIView):
    pass


__all__ = (
    'LCGenericAPIView',
    'LCCreateAPIView',
    'LCListAPIView',
    'LCRetrieveAPIView',
    'LCDestroyAPIView',
    'LCUpdateAPIView',
    'LCRetrieveDestroyAPIView',
    'LCRetrieveUpdateAPIView',
    'LCListCreateAPIView',
    'LCRetrieveUpdateDestroyAPIView',
    'LCRetrieveUpdateDestroyAPIView',
)
