#!/usr/bin/env python
import re
from setuptools import find_packages, setup


def get_version():
    with open('console_webauthn/__init__.py', 'r') as f:
        line = f.readline()
        match = re.match(r'__version__ = \'([\d\.]+)\'', line)

        if not match:
            raise ImportError("Can't read the version of console_webauthn")

        version = match.group(1)
        return version


def read_me():
    with open('README.md') as read:
        return read.read()


def requirements():
    with open('requirements.txt') as req:
        print([r.strip() for r in req.readlines()])
        return [r.strip() for r in req.readlines()]


setup(
    name='console-webauthn',
    version=get_version(),
    description="""A lightweight library for adding WebAuthn support to Compass Consoles.""",
    long_description=read_me(),
    long_description_content_type='text/markdown',
    author='Dave Burkholder',
    author_email='dave@compassfoundation.io',
    url='https://code.compassfoundation.io/clavis/console-webauthn',
    packages=find_packages(exclude=[
        'tests',
    ]),
    include_package_data=True,
    install_requires=requirements(),
    zip_safe=False,
    keywords='console-webauthn',
    classifiers=[
        'Development Status :: 5 - Production/Stable',
        'Framework :: Django',
        'Framework :: Django :: 3.2',
        'Intended Audience :: Developers',
        'Operating System :: MacOS',
        'Operating System :: POSIX :: Linux',
        'Natural Language :: English',
        'Programming Language :: Python :: 3.9',
    ],
)
