from django.urls import path
from . import views

app_name = 'console_webauthn'

urlpatterns = [
    path('credential/update/<uuid:pk>/', views.CredentialUpdate.as_view(), name='credential_update'),
    path('credential/detail/<uuid:pk>/', views.CredentialDetail.as_view(), name='credential_detail'),
    path('credential/delete/<uuid:pk>/', views.CredentialDelete.as_view(), name='credential_delete'),
    path('credential/toggle/<uuid:pk>/', views.CredentialDelete.as_view(), name='credential_toggle'),
    path('register/', views.WebAuthnRegister.as_view(), name='register'),
    path('login/', views.WebAuthnLogin.as_view(), name='login'),
]
