

up.compiler('#webauthn_register', function (element, params) {
    "use strict";

    const { startRegistration } = SimpleWebAuthnBrowser;
    const elemBegin = document.getElementById('btn_webauthn_begin');
    const elemSuccess = document.getElementById('btn_webauthn_success');
    const elemError = document.getElementById('btn_webauthn_error');

    // Start registration when the user clicks a button
    elemBegin.addEventListener('click', async () => {
        // Reset success/error messages

        // GET registration options from the endpoint that calls
        // @simplewebauthn/server -> generateRegistrationOptions()
        const resp = params.public_credential_creation_options;

        let attestResp;
        try {
            // Pass the options to the authenticator and wait for a response
            attestResp = await startRegistration(resp);
        } catch (error) {
          // Some basic error handling
          if (error.name === 'InvalidStateError') {
              elemError.innerText = 'Error';
          } else {
              elemError.innerText = 'Error: '+ error;
          }
          throw error;
        }

        // POST the response to the endpoint that calls
        // @simplewebauthn/server -> verifyRegistrationResponse()
        const verificationResp = await fetch(params.verification_url, {
          method: 'POST',
          headers: {
              'X-CSRFToken': params.csrf_token,
              'Content-Type': 'application/json',
          },
          body:  JSON.stringify(attestResp),
        });

        // Wait for the results of verification
        const verificationJSON = await verificationResp;

        // Show UI appropriate for the `verified` status
        // after credential is added
        if (verificationJSON.status === 201) {
            window.location.replace(params.verified_url);
        } else {
            location.reload();
        }
    });

});
