# Generated by Django 3.2.12 on 2022-07-20 01:32

import console_base.models.fields
import console_base.models.mixins
import console_deps.dirtyfields.dirtyfields
from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import sequential_uuids.generators


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Registration',
            fields=[
                ('id', console_base.models.fields.UUID6Field(default=sequential_uuids.generators.uuid_time_nextval, editable=False, primary_key=True, serialize=False)),
                ('cid', console_base.models.fields.CanonicalIdField(db_index=True, default=sequential_uuids.generators.uuid_time_nextval, help_text='Canonical ID assigned to this record, locally or on external systems. Should not be changed, except to reconcile sync errors.', unique=True)),
                ('created', console_base.models.fields.LCDateTimeField(default=django.utils.timezone.now)),
                ('modified', console_base.models.fields.LCDateTimeField(default=django.utils.timezone.now)),
                ('is_active', models.BooleanField(default=True)),
                ('challenge', models.TextField(blank=True, null=True)),
                ('user', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'registration',
                'verbose_name_plural': 'registrations',
            },
            bases=(console_base.models.mixins.FilterFields, console_deps.dirtyfields.dirtyfields.DirtyFieldsMixin, models.Model),
        ),
        migrations.CreateModel(
            name='Credential',
            fields=[
                ('id', console_base.models.fields.UUID6Field(default=sequential_uuids.generators.uuid_time_nextval, editable=False, primary_key=True, serialize=False)),
                ('cid', console_base.models.fields.CanonicalIdField(db_index=True, default=sequential_uuids.generators.uuid_time_nextval, help_text='Canonical ID assigned to this record, locally or on external systems. Should not be changed, except to reconcile sync errors.', unique=True)),
                ('created', console_base.models.fields.LCDateTimeField(default=django.utils.timezone.now)),
                ('modified', console_base.models.fields.LCDateTimeField(default=django.utils.timezone.now)),
                ('is_active', models.BooleanField(default=True)),
                ('name', models.TextField(blank=True, null=True, verbose_name='Name')),
                ('credential_public_key', models.TextField(blank=True, null=True)),
                ('credential_id', models.TextField(blank=True, null=True)),
                ('current_sign_count', models.PositiveIntegerField(default=0)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='webauthn', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'device',
                'verbose_name_plural': 'devices',
            },
            bases=(console_base.models.mixins.FilterFields, console_deps.dirtyfields.dirtyfields.DirtyFieldsMixin, models.Model),
        ),
        migrations.CreateModel(
            name='Authentication',
            fields=[
                ('id', console_base.models.fields.UUID6Field(default=sequential_uuids.generators.uuid_time_nextval, editable=False, primary_key=True, serialize=False)),
                ('cid', console_base.models.fields.CanonicalIdField(db_index=True, default=sequential_uuids.generators.uuid_time_nextval, help_text='Canonical ID assigned to this record, locally or on external systems. Should not be changed, except to reconcile sync errors.', unique=True)),
                ('created', console_base.models.fields.LCDateTimeField(default=django.utils.timezone.now)),
                ('modified', console_base.models.fields.LCDateTimeField(default=django.utils.timezone.now)),
                ('is_active', models.BooleanField(default=True)),
                ('challenge', models.TextField(blank=True, null=True)),
                ('user', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'authentication',
                'verbose_name_plural': 'authentications',
            },
            bases=(console_base.models.mixins.FilterFields, console_deps.dirtyfields.dirtyfields.DirtyFieldsMixin, models.Model),
        ),
        migrations.AddConstraint(
            model_name='credential',
            constraint=models.UniqueConstraint(fields=('credential_id',), name='device_unique_credential_id'),
        ),
        migrations.AddConstraint(
            model_name='credential',
            constraint=models.UniqueConstraint(fields=('name', 'user'), name='name_user_user_unique'),
        ),
    ]
