from unpoly.forms import UnpolyCrispyFormMixin
from django.conf import settings
from django import forms

from crispy_forms.layout import Layout, Field
from console_base.forms import (
    LCBooleanButtonField,
    RadioButtons,
    save_clear_buttons,
)

from .models import Credential


# -------------------------------------------------------------------------
class CredentialForm(UnpolyCrispyFormMixin, forms.ModelForm):

    name = forms.CharField()
    is_active = LCBooleanButtonField(initial=True, status_button=True)

    def __init__(self, *args, **kwargs):
        self.user = kwargs.pop('user', None)
        for kw in (
                'initial',
                settings.CLONING_RECORD_KEY,
                settings.UNIVERSAL_RECORD_KEY,
                settings.MULTI_LAYER,
        ):
            kwargs.pop(kw, None)
        super().__init__(*args, **kwargs)
        self.helper.layout = Layout(
            Field(
                'name',
                autofocus='autofocus',
                placeholder='Credential Name',
            ),
            RadioButtons('is_active'),
            save_clear_buttons,
        )

    class Meta:
        model = Credential
        fields = (
            'name',
            'is_active',
        )
