from django.contrib import admin
from django.http import HttpResponse, JsonResponse
from django.urls import re_path


def read_session(request):
    return JsonResponse(dict(request.session))


def modify_session(request):
    request.session["FOO"] = "BAR"
    return HttpResponse("")


urlpatterns = [
    re_path(r"^read_session/$", read_session),
    re_path(r"^modify_session/$", modify_session),
    re_path(r"^admin/", admin.site.urls),
]
