import os
from setuptools import setup, find_packages

with open(os.path.join(os.path.dirname(__file__), "README.rst"), "r", encoding="UTF-8") as readme:
    README = readme.read()

# allow setup.py to be run from any path
os.chdir(os.path.normpath(os.path.join(os.path.abspath(__file__), os.pardir)))

dev_requirements = [
    "geoip2",  # for testing GeoIP2
    "pytest",
    "pytest-cov",
    "pytest-django",
]

setup(
    name="console-sessions",
    version="0.1.0",
    description="Console session backends for Compass projects",
    long_description=README,
    author="Dave Burkholder",
    url="https://code.compassfoundation.io/clavis/console-sessions",
    license="SAP",
    packages=find_packages(".", include=("console_sessions", "console_sessions.*")),
    include_package_data=True,
    install_requires=[
        "django-ipware",
        "geoip2",
    ],
    extras_require={"dev": dev_requirements},
    tests_require=dev_requirements,
    classifiers=[
        "Development Status :: 5 - Production/Stable",
        "Environment :: Web Environment",
        "Framework :: Django",
        "Framework :: Django :: 3.1",
        "Intended Audience :: Developers",
        "Operating System :: OS Independent",
        "Programming Language :: Python",
        "Programming Language :: Python :: 3.9",
        "Topic :: Internet :: WWW/HTTP :: Session",
        "Topic :: Security",
    ],
)
