import logging

logger = logging.getLogger(__name__)
CONTENT_TYPE_COMPRESSED_JSON = 'compressed/json'
CONTENT_TYPE_JSON = 'json'


class BaseConcordiaClient:
    """
    Create base Clarion client for typical portal operations.
    """

    def publish(
        self,
        room: str,
        payload: dict | None = None,
    ) -> dict:
        print(f'Publish {payload} to {room}')
        return payload or {}


class ConcordiaClient(BaseConcordiaClient):
    """
    General client class to use for Publishing / Subscribing to Concord MQ rooms.
    """

    ...


__all__ = (
    'BaseConcordiaClient',
    'ConcordiaClient',
)
