# Generated by Django 4.2.10 on 2024-02-27 22:49

import concordia.querysets
import console_base.models.constraints
import console_base.models.fields
import console_base.models.mixins
import console_deps.dirtyfields.dirtyfields
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import sequential_uuids.generators


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ("pghistory", "0006_delete_aggregateevent"),
        ("contenttypes", "0002_remove_content_type_name"),
    ]

    operations = [
        migrations.CreateModel(
            name="ConcordEvents",
            fields=[],
            options={
                "verbose_name_plural": "concord events",
                "proxy": True,
                "indexes": [],
                "constraints": [],
            },
            bases=("pghistory.events",),
        ),
        migrations.CreateModel(
            name="ConcordiaContentType",
            fields=[],
            options={
                "proxy": True,
                "indexes": [],
                "constraints": [],
            },
            bases=("contenttypes.contenttype",),
            managers=[
                ("objects", concordia.querysets.ConcordiaContentTypeManager()),
            ],
        ),
        migrations.CreateModel(
            name="CanonicalIdSwap",
            fields=[
                ("created", models.DateTimeField(default=django.utils.timezone.now)),
                ("modified", models.DateTimeField(default=django.utils.timezone.now)),
                ("is_active", models.BooleanField(default=True)),
                (
                    "id",
                    console_base.models.fields.UUID6Field(
                        default=sequential_uuids.generators.uuid_time_nextval,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "cid",
                    console_base.models.fields.CanonicalIdField(
                        default=sequential_uuids.generators.uuid_time_nextval,
                        help_text="Canonical ID assigned to this record, locally or on external systems. Should not be changed, except to reconcile sync errors.",
                    ),
                ),
                ("name", models.TextField()),
                ("object_id", models.TextField(blank=True, null=True)),
                ("old", models.UUIDField()),
                (
                    "table",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="contenttypes.contenttype",
                    ),
                ),
            ],
            options={
                "verbose_name_plural": "canonical id map",
            },
            bases=(
                console_base.models.mixins.FilterFields,
                console_deps.dirtyfields.dirtyfields.DirtyFieldsMixin,
                models.Model,
            ),
        ),
        migrations.CreateModel(
            name="CanonicalIdMap",
            fields=[
                ("created", models.DateTimeField(default=django.utils.timezone.now)),
                ("modified", models.DateTimeField(default=django.utils.timezone.now)),
                ("is_active", models.BooleanField(default=True)),
                (
                    "id",
                    console_base.models.fields.UUID6Field(
                        default=sequential_uuids.generators.uuid_time_nextval,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "cid",
                    console_base.models.fields.CanonicalIdField(
                        default=sequential_uuids.generators.uuid_time_nextval,
                        help_text="Canonical ID assigned to this record, locally or on external systems. Should not be changed, except to reconcile sync errors.",
                    ),
                ),
                ("name", models.TextField()),
                ("object_id", models.TextField(blank=True, null=True)),
                ("local", models.UUIDField()),
                (
                    "table",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="contenttypes.contenttype",
                    ),
                ),
            ],
            options={
                "verbose_name_plural": "canonical id map",
            },
            bases=(
                console_base.models.mixins.FilterFields,
                console_deps.dirtyfields.dirtyfields.DirtyFieldsMixin,
                models.Model,
            ),
        ),
        migrations.CreateModel(
            name="CanonicalIdDeleteLog",
            fields=[
                ("created", models.DateTimeField(default=django.utils.timezone.now)),
                ("modified", models.DateTimeField(default=django.utils.timezone.now)),
                ("is_active", models.BooleanField(default=True)),
                (
                    "id",
                    console_base.models.fields.UUID6Field(
                        default=sequential_uuids.generators.uuid_time_nextval,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "cid",
                    console_base.models.fields.CanonicalIdField(
                        default=sequential_uuids.generators.uuid_time_nextval,
                        help_text="Canonical ID assigned to this record, locally or on external systems. Should not be changed, except to reconcile sync errors.",
                    ),
                ),
                ("name", models.TextField()),
                ("object_id", models.TextField(blank=True, null=True)),
                (
                    "table",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="contenttypes.contenttype",
                    ),
                ),
            ],
            options={
                "verbose_name_plural": "canonical id delete",
            },
            bases=(
                console_base.models.mixins.FilterFields,
                console_deps.dirtyfields.dirtyfields.DirtyFieldsMixin,
                models.Model,
            ),
        ),
        migrations.AddConstraint(
            model_name="canonicalidswap",
            constraint=models.CheckConstraint(
                check=models.Q(("cid", models.F("old")), _negated=True),
                name="old_cid_differs_from_new_cid",
                violation_error_message="Old CID must differ from new CID",
            ),
        ),
        migrations.AddConstraint(
            model_name="canonicalidswap",
            constraint=console_base.models.constraints.LCUniqueConstraint(
                fields=("object_id", "old"),
                name="old_canonical_id_unique",
                violation_error_message="Record swapping this old Canonical ID already exists.",
            ),
        ),
        migrations.AddConstraint(
            model_name="canonicalidmap",
            constraint=models.CheckConstraint(
                check=models.Q(("cid", models.F("local")), _negated=True),
                name="local_cid_differs_from_global_cid",
                violation_error_message="Local CID must differ from global CID",
            ),
        ),
        migrations.AddConstraint(
            model_name="canonicalidmap",
            constraint=console_base.models.constraints.LCUniqueConstraint(
                condition=models.Q(("object_id__isnull", False)),
                fields=("object_id", "local"),
                name="local_canonical_id_unique",
                violation_error_message="Local record mapping to Canonical ID already exists.",
            ),
        ),
        migrations.AddConstraint(
            model_name="canonicaliddeletelog",
            constraint=console_base.models.constraints.LCUniqueConstraint(
                fields=("cid",),
                name="deleted_canonical_id_unique",
                violation_error_message="Delete record for this Canonical ID already exists.",
            ),
        ),
    ]
