from console_base.choices import LCTextChoicesMixin
from django.db.models import TextChoices
from django.utils.translation import gettext_lazy as tr


# ---------------------------------------------------------------------------
class CONTEXT(LCTextChoicesMixin, TextChoices):
    Event = 'pgh_context', tr('Context from local Concord Event')
    Origin = 'origin_context', tr("Subscriber's original Concord Event Context")
    Keys = 'keys', tr("Context Keys from Subscriber's Event Context")


# ---------------------------------------------------------------------------
class SYNCMODES(LCTextChoicesMixin, TextChoices):
    """
    Should records be deleted on the local console only,
    or synchronized among all the consoles?
    """

    Sync = 'sync', tr('Sync Everywhere')
    Local = 'local', tr('Local System Only')


# ---------------------------------------------------------------------------
class CRUD(LCTextChoicesMixin, TextChoices):
    Create = 'create', 'Create'
    Update = 'update', 'Update'
    Delete = 'delete', 'Delete'
    Toggle = 'toggle', 'Toggle'


# ---------------------------------------------------------------------------
class ORIGIN_SERVER(LCTextChoicesMixin, TextChoices):
    CID = 'origin_server_cid', tr('Origin Appliance / Server CID')
    Name = 'origin_server_name', tr('Origin Appliance / Server Name')
